/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.domain;

/**
 * Enum for Message Type Indic.
 */
public enum MessageTypeIndicEnum {

    /**
     * Cesop 100 message type for new data.
     */
    CESOP100("CESOP100"), // new data
    /**
     * Cesop 101 message type for corrections.
     */
    CESOP101("CESOP101"), // corrections
    /**
     * Cesop 102 message type for no data.
     */
    CESOP102("CESOP102"); // no data

    private final String label;

    MessageTypeIndicEnum(final String label) {
        this.label = label;
    }

    /**
     * Gets label.
     *
     * @return the label
     */
    public String getLabel() {
        return this.label;
    }

    /**
     * Find a {@link MessageTypeIndicEnum} by its label.
     *
     * @param label the label
     * @return the {@link MessageTypeIndicEnum}
     * @throws IllegalArgumentException if there is no value for the label
     */
    public static MessageTypeIndicEnum findByLabel(final String label) {
        for (final MessageTypeIndicEnum value : values()) {
            if (value.getLabel().equals(label)) {
                return value;
            }
        }
        throw new IllegalArgumentException("No MessageTypeIndicEnum found for label: " + label);
    }
}
